/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.models.blockbench.animation;

import com.cobblemon.mod.common.client.render.models.blockbench.ModelPartExtensionsKt;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.animation.PoseAnimation;
import com.cobblemon.mod.common.client.render.models.blockbench.animation.WaveSegment;
import com.cobblemon.mod.common.client.render.models.blockbench.pose.Bone;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0018\u0018\u00002\u00020\u0001Bi\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\n\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014JW\u0010\"\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b\"\u0010#R'\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010$\u001a\u0004\b%\u0010&R\u0017\u0010\u0006\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010'\u001a\u0004\b(\u0010)R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010*\u001a\u0004\b+\u0010,R\u0017\u0010\t\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\t\u0010'\u001a\u0004\b-\u0010)R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010.\u001a\u0004\b/\u00100R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u00101\u001a\u0004\b2\u00103R\u0017\u0010\u000e\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u00101\u001a\u0004\b4\u00103R\u0017\u0010\u000f\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010.\u001a\u0004\b5\u00100R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0012\u00106\u001a\u0004\b7\u00108\u00a8\u00069"}, d2={"Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/WaveAnimation;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/PoseAnimation;", "Lkotlin/Function1;", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/wavefunction/WaveFunction;", "waveFunction", "oscillationsScalar", "Lnet/minecraft/class_630;", "head", "headLength", "", "moveHead", "", "rotationAxis", "motionAxis", "basedOnLimbSwing", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/WaveSegment;", "segments", "<init>", "(Lkotlin/jvm/functions/Function1;FLnet/minecraft/class_630;FZIIZ[Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/WaveSegment;)V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "context", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;", "model", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;", "state", "limbSwing", "limbSwingAmount", "ageInTicks", "headYaw", "headPitch", "intensity", "", "setupAnim", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;FFFFFF)V", "Lkotlin/jvm/functions/Function1;", "getWaveFunction", "()Lkotlin/jvm/functions/Function1;", "F", "getOscillationsScalar", "()F", "Lnet/minecraft/class_630;", "getHead", "()Lnet/minecraft/class_630;", "getHeadLength", "Z", "getMoveHead", "()Z", "I", "getRotationAxis", "()I", "getMotionAxis", "getBasedOnLimbSwing", "[Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/WaveSegment;", "getSegments", "()[Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/WaveSegment;", "common"})
@SourceDebugExtension(value={"SMAP\nWaveAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaveAnimation.kt\ncom/cobblemon/mod/common/client/render/models/blockbench/animation/WaveAnimation\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,99:1\n11561#2:100\n11896#2,3:101\n*S KotlinDebug\n*F\n+ 1 WaveAnimation.kt\ncom/cobblemon/mod/common/client/render/models/blockbench/animation/WaveAnimation\n*L\n60#1:100\n60#1:101,3\n*E\n"})
public final class WaveAnimation
extends PoseAnimation {
    @NotNull
    private final Function1<Float, Float> waveFunction;
    private final float oscillationsScalar;
    @NotNull
    private final class_630 head;
    private final float headLength;
    private final boolean moveHead;
    private final int rotationAxis;
    private final int motionAxis;
    private final boolean basedOnLimbSwing;
    @NotNull
    private final WaveSegment[] segments;

    public WaveAnimation(@NotNull Function1<? super Float, Float> waveFunction, float oscillationsScalar, @NotNull class_630 head, float headLength, boolean moveHead, int rotationAxis, int motionAxis, boolean basedOnLimbSwing, @NotNull WaveSegment[] segments) {
        Intrinsics.checkNotNullParameter(waveFunction, (String)"waveFunction");
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        this.waveFunction = waveFunction;
        this.oscillationsScalar = oscillationsScalar;
        this.head = head;
        this.headLength = headLength;
        this.moveHead = moveHead;
        this.rotationAxis = rotationAxis;
        this.motionAxis = motionAxis;
        this.basedOnLimbSwing = basedOnLimbSwing;
        this.segments = segments;
    }

    public /* synthetic */ WaveAnimation(Function1 function1, float f, class_630 class_6302, float f2, boolean bl, int n, int n2, boolean bl2, WaveSegment[] waveSegmentArray, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        if ((n3 & 0x80) != 0) {
            bl2 = false;
        }
        this((Function1<? super Float, Float>)function1, f, class_6302, f2, bl, n, n2, bl2, waveSegmentArray);
    }

    @NotNull
    public final Function1<Float, Float> getWaveFunction() {
        return this.waveFunction;
    }

    public final float getOscillationsScalar() {
        return this.oscillationsScalar;
    }

    @NotNull
    public final class_630 getHead() {
        return this.head;
    }

    public final float getHeadLength() {
        return this.headLength;
    }

    public final boolean getMoveHead() {
        return this.moveHead;
    }

    public final int getRotationAxis() {
        return this.rotationAxis;
    }

    public final int getMotionAxis() {
        return this.motionAxis;
    }

    public final boolean getBasedOnLimbSwing() {
        return this.basedOnLimbSwing;
    }

    @NotNull
    public final WaveSegment[] getSegments() {
        return this.segments;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupAnim(@NotNull RenderContext context, @NotNull PosableModel model, @NotNull PosableState state, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch, float intensity) {
        Collection<Float> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        float t = this.basedOnLimbSwing ? limbSwing : state.getAnimationSeconds();
        WaveSegment[] waveSegmentArray = this.segments;
        float f = this.headLength;
        boolean $i$f$map = false;
        WaveSegment[] waveSegmentArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var20_27 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(it.getLength()));
        }
        collection = (List)destination$iv$iv;
        float totalTimeDisplacement = (f + CollectionsKt.sumOfFloat((Iterable)collection)) / this.oscillationsScalar;
        if (this.moveHead) {
            float headDisplacement = ((Number)this.waveFunction.invoke((Object)Float.valueOf(t + totalTimeDisplacement - this.headLength / this.oscillationsScalar))).floatValue() * (float)16;
            ModelPartExtensionsKt.addPosition(this.head, this.motionAxis, -headDisplacement * intensity);
        }
        totalTimeDisplacement -= this.headLength / this.oscillationsScalar;
        float previousSegmentLength = this.headLength;
        float previousTheta = 0.0f;
        for (WaveSegment segment : this.segments) {
            float t2 = totalTimeDisplacement + previousSegmentLength / (float)2 / this.oscillationsScalar;
            float t1 = totalTimeDisplacement - segment.getLength() / (float)2 / this.oscillationsScalar;
            float yAfter = ((Number)this.waveFunction.invoke((Object)Float.valueOf(t + t1))).floatValue();
            float yBefore = ((Number)this.waveFunction.invoke((Object)Float.valueOf(t + t2))).floatValue();
            float ratio = (yAfter - yBefore) / (t2 - t1);
            float theta = (float)Math.atan(ratio);
            ModelPartExtensionsKt.addRotation((Bone)segment.getModelPart(), this.rotationAxis, (theta - previousTheta) * intensity);
            previousTheta = theta;
            previousSegmentLength = segment.getLength();
            totalTimeDisplacement -= segment.getLength() / this.oscillationsScalar;
            if (!(totalTimeDisplacement < 0.0f)) continue;
            totalTimeDisplacement = 0.0f;
        }
    }
}

